<?php
global $ElementorPageIntro;
?>
<div class="wrap">
    <h2><?php echo esc_html__('Page Intro Elementor','elementor-page-intro'); ?></h2>

    <form method="post" action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>">
    	<?php $ElementorPageIntro->the_nonce(); ?>
    	<table class="form-table">
			<tbody>
				<tr>
					<th scope="row" valign="top"><?php echo esc_html__('Active','elementor-page-intro'); ?></th>
					<td>
						<label>
							<select name="<?php echo esc_html($ElementorPageIntro->get_field_name('page_intro_active')); ?>">
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_active') === 'yes') ? 'selected' : '' ; ?>
								<option value="yes" <?php echo  esc_html($selected); ?>><?php echo esc_html__('Active','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_active') === 'no') ? 'selected' : '' ; ?>
								<option value="no" <?php echo  esc_html($selected); ?>><?php echo esc_html__('Deactive','elementor-page-intro'); ?></option>			
							</select>
						</label>
					</td>
				</tr>
				<tr>
					<th scope="row" valign="top"><?php echo esc_html__('Active Only HomePage / Pages','elementor-page-intro'); ?></th>
					<td>
						<label>
							<select name="<?php echo  esc_html($ElementorPageIntro->get_field_name('page_intro_active_pages')); ?>">
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_active_pages') === 'homepage') ? 'selected' : '' ; ?>
								<option value="homepage" <?php echo  esc_html($selected); ?>><?php echo esc_html__('Only Homepage','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_active_pages') === 'allpages') ? 'selected' : '' ; ?>
								<option value="allpages" <?php echo  esc_html($selected); ?>><?php echo esc_html__('All Pages','elementor-page-intro'); ?></option>			
							</select>
						</label>
					</td>
				</tr>				
				<tr>
					<th scope="row" valign="top"><?php echo esc_html__('Select Page','elementor-page-intro'); ?></th>
					<td>
						<label>
<select name="<?php echo  esc_html($ElementorPageIntro->get_field_name('page_intro_id')); ?>"> 
    <option selected="selected" disabled="disabled" value=""><?php echo esc_html__('Select Page','elementor-page-intro'); ?></option> 
    <?php
        $selected_page = $ElementorPageIntro->get_setting('page_intro_id');
        $pages = get_pages(); 
        foreach ( $pages as $page ) {
            echo  '<option value="' . $page->ID . '" ';
            if($page->ID == $selected_page ) { 
				echo 'selected="selected"';
			}
            echo '>';
            echo esc_html($page->post_title);
            echo '</option>';
        }
    ?>
</select>
						</label>
					</td>
				</tr>
				<tr>
					<th scope="row" valign="top"><?php echo esc_html__('Intro Type','elementor-page-intro'); ?></th>
					<td>
						<label>
							<select name="<?php echo  esc_html($ElementorPageIntro->get_field_name('page_intro_type')); ?>">
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_type') === 'normal') ? 'selected' : '' ; ?>
								<option value="normal" <?php echo  esc_html($selected); ?>><?php echo esc_html__('Normal','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_type') === 'session') ? 'selected' : '' ; ?>
								<option value="session" <?php echo  esc_html($selected); ?>><?php echo esc_html__('Session','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_type') === 'cookie') ? 'selected' : '' ; ?>
								<option value="cookie" <?php echo  esc_html($selected); ?>><?php echo esc_html__('Cookie','elementor-page-intro'); ?></option>							
							</select>
						</label>
					</td>
				</tr>
				<tr>
					<th scope="row" valign="top"><?php echo esc_html__('Cookie Value','elementor-page-intro'); ?></th>
					<td>
						<label>
							<select name="<?php echo  esc_html($ElementorPageIntro->get_field_name('page_intro_cookie_value')); ?>">
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '60') ? 'selected' : '' ; ?>
								<option value="60" <?php echo  esc_html($selected); ?>><?php echo esc_html__('1 Minute','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '300') ? 'selected' : '' ; ?>
								<option value="300" <?php echo esc_html($selected); ?>><?php echo esc_html__('5 Minutes','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '900') ? 'selected' : '' ; ?>
								<option value="900" <?php echo esc_html($selected); ?>><?php echo esc_html__('15 Minutes','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '1800') ? 'selected' : '' ; ?>
								<option value="1800" <?php echo esc_html($selected); ?>><?php echo esc_html__('30 Minutes','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '3600') ? 'selected' : '' ; ?>
								<option value="3600" <?php echo esc_html($selected); ?>><?php echo esc_html__('60 Minutes','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '7200') ? 'selected' : '' ; ?>
								<option value="7200" <?php echo esc_html($selected); ?>><?php echo esc_html__('2 Hours','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '21600') ? 'selected' : '' ; ?>
								<option value="21600" <?php echo esc_html($selected); ?>><?php echo esc_html__('6 Hours','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '43200') ? 'selected' : '' ; ?>
								<option value="43200" <?php echo esc_html($selected); ?>><?php echo esc_html__('12 Hours','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '86400') ? 'selected' : '' ; ?>
								<option value="86400" <?php echo esc_html($selected); ?>><?php echo esc_html__('24 Hours','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '172800') ? 'selected' : '' ; ?>
								<option value="172800" <?php echo esc_html($selected); ?>><?php echo esc_html__('2 Days','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '604800') ? 'selected' : '' ; ?>
								<option value="604800" <?php echo esc_html($selected); ?>><?php echo esc_html__('7 Days','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '1209600') ? 'selected' : '' ; ?>
								<option value="1209600" <?php echo esc_html($selected); ?>><?php echo esc_html__('14 Days','elementor-page-intro'); ?></option>
								<?php $selected = ($ElementorPageIntro->get_setting('page_intro_cookie_value') === '2592000') ? 'selected' : '' ; ?>
								<option value="2592000" <?php echo esc_html($selected); ?>><?php echo esc_html__('1 Month','elementor-page-intro'); ?></option>								
							</select>
						</label>
					</td>
				</tr>	
				<tr>
					<th scope="row" valign="top"><?php echo esc_html__('Url Favicon','elementor-page-intro'); ?></th>
					<td>
						<label>
							<input type="text" name="<?php echo esc_url($ElementorPageIntro->get_field_name('favicon_url')); ?>" value="<?php echo esc_url($ElementorPageIntro->get_setting('favicon_url')); ?>" /><br />
						</label>
					</td>
				</tr>
			</tbody>
    	</table>
    	<input class="button-primary" type="submit" value="Save Settings" />
    </form>
</div>